implementation module htoclean_file;

// for windows

import StdEnv;

import code from "program_args.o";

n_args :: Int;
n_args = code {
	ccall n_args "-I"
}

program_arg :: !Int -> {#Char};
program_arg i = code {
	ccall program_arg "I-S"
}

DirectorySeparator :== '\\';

wait_for_keypress :: !*World -> *World;
wait_for_keypress w
	# (stdio,w) = stdio w;
	  stdio = stdio <<< "Press any key to exit";
	  (ok,c,stdio) = freadc stdio;
	  (ok,w) = fclose stdio w;
	= w;

get_path_name :: !*World -> (!Bool,!String,!*World);
get_path_name w
	# n_arguments=n_args;
	| n_arguments<>2
		# stderr=fwrites "Usage: htoclean h_file_name\n" stderr;
		  stderr=fwrites "Generates a .icl and .dcl file for a c header file\n" stderr;
		  (_,w) = fclose stderr w;
		  w = wait_for_keypress w;
		= (False,"",w);
		# path_name = program_arg 1;
		= (True,path_name,w);
